/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.swagger.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import top.lshaci.framework.swagger.model.DocketInfo;
import top.lshaci.framework.swagger.properties.FrameworkSwaggerProperties;

@Configuration
@EnableSwagger2
@EnableConfigurationProperties(value={FrameworkSwaggerProperties.class})
@ConditionalOnProperty(prefix="framework.swagger", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class FrameworkSwaggerConfig
implements BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(FrameworkSwaggerConfig.class);
    @Autowired
    private FrameworkSwaggerProperties properties;
    private BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    public List<Docket> docket() {
        log.debug("Init Swagger UI Config...");
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        if (this.properties.getDocket().isEmpty()) {
            Docket defaultDocket = this.defaultDocket();
            configurableBeanFactory.registerSingleton("defaultDocket", (Object)defaultDocket);
            return null;
        }
        LinkedList<Docket> docketList = new LinkedList<Docket>();
        this.properties.getDocket().forEach((groupName, docketInfo) -> {
            Docket docket = this.docket((String)groupName, (DocketInfo)docketInfo);
            configurableBeanFactory.registerSingleton(groupName, (Object)docket);
            docketList.add(this.defaultDocket());
        });
        return docketList;
    }

    private Docket docket(String groupName, DocketInfo docketInfo) {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo(docketInfo)).groupName(groupName).directModelSubstitute(Byte.class, Integer.class).select().apis(RequestHandlerSelectors.basePackage((String)docketInfo.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(docketInfo.excludePath())), (Predicate)Predicates.or(docketInfo.basePath()))).build().globalOperationParameters(this.properties.globalParameter());
    }

    private ApiInfo apiInfo(DocketInfo docketInfo) {
        return new ApiInfoBuilder().title(docketInfo.getTitle().isEmpty() ? this.properties.getTitle() : docketInfo.getTitle()).description(docketInfo.getDescription().isEmpty() ? this.properties.getDescription() : docketInfo.getDescription()).termsOfServiceUrl(docketInfo.getTermsOfServiceUrl().isEmpty() ? this.properties.getTermsOfServiceUrl() : docketInfo.getTermsOfServiceUrl()).contact(docketInfo.getContact().get()).version(docketInfo.getVersion().isEmpty() ? this.properties.getVersion() : docketInfo.getVersion()).license(docketInfo.getLicense().isEmpty() ? this.properties.getLicense() : docketInfo.getLicense()).licenseUrl(docketInfo.getLicenseUrl().isEmpty() ? this.properties.getLicenseUrl() : docketInfo.getLicenseUrl()).build();
    }

    private Docket defaultDocket() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.defaultApiInfo()).directModelSubstitute(Byte.class, Integer.class).select().apis(RequestHandlerSelectors.basePackage((String)this.properties.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(this.properties.excludePath())), (Predicate)Predicates.or(this.properties.basePath()))).build().globalOperationParameters(this.properties.globalParameter());
    }

    private ApiInfo defaultApiInfo() {
        return new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).termsOfServiceUrl(this.properties.getTermsOfServiceUrl()).contact(this.properties.getContact().get()).version(this.properties.getVersion()).license(this.properties.getLicense()).licenseUrl(this.properties.getLicenseUrl()).build();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

