/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.thread.masterworker;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import top.lshaci.framework.thread.masterworker.Task;
import top.lshaci.framework.thread.masterworker.Worker;
import top.lshaci.framework.thread.utils.ExecutorUtils;

public class Master<R> {
    private static final int DEFAULT_WORKER_NUMBER = ExecutorUtils.PROCESSORS * 2;
    private ConcurrentLinkedQueue<Task<R>> taskQueue = new ConcurrentLinkedQueue();
    private HashMap<String, Worker<R>> workers = new HashMap();
    private ConcurrentHashMap<String, R> result = new ConcurrentHashMap();
    private long delayMillis;

    public Master() {
        this(10L, DEFAULT_WORKER_NUMBER);
    }

    public Master(long delayMillis, int workerNumber) {
        if (delayMillis < 0L || workerNumber <= 0) {
            throw new IllegalArgumentException();
        }
        this.delayMillis = delayMillis;
        for (int i = 0; i < workerNumber; ++i) {
            this.workers.put("worker:" + i, new Worker<R>(this.taskQueue, this.result));
        }
    }

    public void submit(Task<R> task) {
        this.taskQueue.add(task);
    }

    public void execute() {
        this.workers.forEach((key, worker) -> ExecutorUtils.execute(() -> worker.run()));
    }

    public boolean isComplete() {
        for (Map.Entry<String, Worker<R>> entry : this.workers.entrySet()) {
            if (entry.getValue().isDone()) continue;
            return false;
        }
        return true;
    }

    public ConcurrentHashMap<String, R> getResult() {
        while (!this.isComplete()) {
            try {
                Thread.sleep(this.delayMillis);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return this.result;
    }
}

