/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FreemarkerUtil {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerUtil.class);
    private static Configuration configuration;

    public static String generate(String name, Object model) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        FreemarkerUtil.generate(name, model, writer);
        return writer.toString();
    }

    public static void generate(String name, Object model, Writer writer) throws IOException, TemplateException {
        configuration.getTemplate(name).process(model, writer);
    }

    public static void generate(String name, Object model, OutputStream outputStream) throws IOException, TemplateException {
        FreemarkerUtil.generate(name, model, new BufferedWriter(new OutputStreamWriter(outputStream, "utf-8"), 10240));
    }

    @Autowired
    public void setConfiguration(Configuration configuration) {
        FreemarkerUtil.configuration = configuration;
    }
}

