/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils.config;

import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactoryBean;
import top.lshaci.framework.utils.FreemarkerUtil;
import top.lshaci.framework.utils.SpringBeanUtil;

@Configuration
public class FrameworkSpringUtilsConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkSpringUtilsConfig.class);

    @Bean
    @ConditionalOnBean(value={FreeMarkerProperties.class})
    public FreemarkerUtil freemarkerUtil(FreeMarkerProperties properties) throws Exception {
        log.debug("Config freemarker util...");
        FreeMarkerConfigurationFactoryBean factory = new FreeMarkerConfigurationFactoryBean();
        factory.setTemplateLoaderPaths(properties.getTemplateLoaderPath());
        factory.setPreferFileSystemAccess(properties.isPreferFileSystemAccess());
        factory.setDefaultEncoding(properties.getCharsetName());
        Properties settings = new Properties();
        settings.putAll((Map<?, ?>)properties.getSettings());
        factory.setFreemarkerSettings(settings);
        factory.afterPropertiesSet();
        FreemarkerUtil freemarkerUtil = new FreemarkerUtil();
        freemarkerUtil.setConfiguration(factory.getObject());
        return freemarkerUtil;
    }

    @Bean
    public SpringBeanUtil springUtil() {
        log.debug("Config spring bean util...");
        return new SpringBeanUtil();
    }
}

