/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.enums.FileType;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class FileTypeUtil {
    private static final Logger log = LoggerFactory.getLogger(FileTypeUtil.class);

    public static FileType getType(File file) throws FileNotFoundException, IOException {
        Objects.requireNonNull(file, "The file must not be null");
        return FileTypeUtil.getType(new FileInputStream(file));
    }

    public static FileType getType(InputStream is) throws UtilException {
        FileType[] fileTypes;
        Objects.requireNonNull(is, "The input stream must not be null");
        String fileHead = FileTypeUtil.getFileHeader(is);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (FileType type : fileTypes = FileType.values()) {
            if (!fileHead.startsWith(type.getValue())) continue;
            return type;
        }
        return null;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private static String getFileHeader(InputStream is) throws UtilException {
        byte[] b = new byte[28];
        try {
            is.read(b, 0, 28);
        }
        catch (IOException e) {
            log.error("Read file has error!", (Throwable)e);
            throw new UtilException("Read file has error!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("Close file has error!", (Throwable)e);
                    throw new UtilException("Close file has error!", e);
                }
            }
        }
        return FileTypeUtil.bytesToHexString(b);
    }
}

