/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static <E> E newInstance(Class<E> clazz) {
        Objects.requireNonNull(clazz, "The class is must not be null!");
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Use reflection new instance is error!", (Throwable)e);
            throw new UtilException("Create instance is error of class is : " + clazz.getName());
        }
    }

    public static Class<?> getInterfaceGenericType(Class<?> clazz) {
        return ReflectionUtils.getInterfaceGenericType(clazz, 0, 0);
    }

    public static Class<?> getInterfaceGenericType(Class<?> clazz, int interfaceIndex, int genericTypeIndex) {
        Objects.requireNonNull(clazz, "The class is must not be null!");
        Type[] interfaces = clazz.getGenericInterfaces();
        ParameterizedType type = (ParameterizedType)interfaces[interfaceIndex];
        Type genericType = type.getActualTypeArguments()[genericTypeIndex];
        return (Class)genericType;
    }

    public static Object invokeMethod(Object obj, Method method, Object ... args) {
        Objects.requireNonNull(obj, "The object is must not be null!");
        Objects.requireNonNull(method, "The method is must not be null!");
        try {
            method.setAccessible(true);
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("Invoke method is error!", (Throwable)e);
            throw new UtilException("Invoke method is error of method is : " + method.getName());
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        Objects.requireNonNull(obj, "The object is must not be null!");
        Objects.requireNonNull(field, "The field is must not be null!");
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error("Set field value is error!", (Throwable)e);
            throw new UtilException("Set field value is error of field is : " + field.getName());
        }
    }
}

