/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteArrayOutputStream copyInputStream(InputStream in) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            StreamUtils.write(in, out);
            ByteArrayOutputStream byteArrayOutputStream = out;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            log.error("Copy input stream error!", (Throwable)e);
            throw new UtilException("Copy input stream error!");
        }
    }

    public static void write(InputStream is, OutputStream os) throws IOException {
        int length;
        byte[] b = new byte[2048];
        while ((length = is.read(b)) > 0) {
            os.write(b, 0, length);
        }
        os.flush();
    }
}

