/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        try {
            return Class.forName(className, isInitialized, ClassUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            String msg = "This class not found of name is " + className;
            log.error(msg, (Throwable)e);
            throw new UtilException(msg);
        }
    }

    public static Class<?> getFieldGenericType(Field field) {
        return ClassUtils.getFieldGenericType(field, 0);
    }

    public static Class<?> getFieldGenericType(Field field, int genericTypeIndex) {
        Objects.requireNonNull(field, "The field is must not be null!");
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[genericTypeIndex];
        }
        throw new UtilException("This field has no generic type");
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz) {
        return ClassUtils.getSuperClassGenericType(clazz, 0);
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz, int genericTypeIndex) {
        Objects.requireNonNull(clazz, "The class is must not be null!");
        Type superclass = clazz.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)superclass).getActualTypeArguments()[genericTypeIndex];
        }
        throw new UtilException("This class has no generic type");
    }

    public static Class<?> getInterfaceGenericType(Class<?> clazz) {
        return ClassUtils.getInterfaceGenericType(clazz, 0, 0);
    }

    public static Class<?> getInterfaceGenericType(Class<?> clazz, int interfaceIndex, int genericTypeIndex) {
        Objects.requireNonNull(clazz, "The class is must not be null!");
        Type[] interfaces = clazz.getGenericInterfaces();
        ParameterizedType type = (ParameterizedType)interfaces[interfaceIndex];
        if (type instanceof ParameterizedType) {
            return (Class)type.getActualTypeArguments()[genericTypeIndex];
        }
        throw new UtilException("This class has no generic type");
    }

    public static Set<Class<?>> getClassSet(String packageName, boolean isRecursion) {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            throw new UtilException("The package name is must not be empty!");
        }
        HashSet classSet = new HashSet();
        String packagePath = packageName.replace(".", "/");
        try {
            Enumeration<URL> urls = ClassUtils.getClassLoader().getResources(packagePath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String path = url.getPath().replaceAll("%20", " ");
                    ClassUtils.addClassFromFile(classSet, path, packageName, isRecursion);
                    continue;
                }
                if ("jar".equals(protocol)) {
                    JarFile jarFile;
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    if (jarURLConnection == null || (jarFile = jarURLConnection.getJarFile()) == null) continue;
                    ClassUtils.addClassFromJar(classSet, jarFile.entries(), packageName, isRecursion);
                    jarFile.close();
                    continue;
                }
                ClassUtils.addClassNameFromJars(classSet, ((URLClassLoader)ClassUtils.getClassLoader()).getURLs(), packageName, isRecursion);
            }
        }
        catch (IOException e) {
            log.error("Get class set is error, the package is " + packageName, (Throwable)e);
        }
        return classSet;
    }

    private static void addClassNameFromJars(Set<Class<?>> classSet, URL[] urls, String packageName, boolean isRecursion) throws IOException {
        for (int i = 0; i < urls.length; ++i) {
            String classPath = urls[i].getPath();
            if (classPath.endsWith("classes/")) continue;
            JarFile jarFile = new JarFile(classPath.substring(classPath.indexOf("/")));
            ClassUtils.addClassFromJar(classSet, jarFile.entries(), packageName, isRecursion);
            jarFile.close();
        }
    }

    private static void addClassFromJar(Set<Class<?>> classSet, Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith(".class")) continue;
            String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
            if (isRecursion) {
                ClassUtils.doAddClass(classSet, className);
                continue;
            }
            if (className.replace(packageName + ".", "").contains(".")) continue;
            ClassUtils.doAddClass(classSet, className);
        }
    }

    private static void addClassFromFile(Set<Class<?>> classSet, String packagePath, String packageName, boolean isRecursion) {
        File[] files = new File(packagePath).listFiles(f -> f.isFile() && f.getName().endsWith(".class") || isRecursion && f.isDirectory());
        if (files != null && files.length > 0) {
            for (File file : files) {
                String fileName = file.getName();
                if (file.isFile()) {
                    String className = fileName.substring(0, fileName.lastIndexOf("."));
                    if (!StringUtils.isEmpty((CharSequence)packageName)) {
                        className = packageName + "." + className;
                    }
                    ClassUtils.doAddClass(classSet, className);
                    continue;
                }
                if (!isRecursion || !file.isDirectory()) continue;
                String subPackagePath = fileName;
                if (!StringUtils.isEmpty((CharSequence)packagePath)) {
                    subPackagePath = packagePath + "/" + subPackagePath;
                }
                String subPackageName = fileName;
                if (!StringUtils.isEmpty((CharSequence)packageName)) {
                    subPackageName = packageName + "/" + subPackageName;
                }
                ClassUtils.addClassFromFile(classSet, subPackagePath, subPackageName, isRecursion);
            }
        }
    }

    private static void doAddClass(Set<Class<?>> classSet, String className) {
        Class<?> clazz = ClassUtils.loadClass(className, false);
        classSet.add(clazz);
    }
}

