/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.common.exception.BaseException;

public class FreemarkerUtils {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerUtils.class);
    private Configuration configuration;
    private String prefix;
    private ThreadLocal<Template> currentTemplate = new ThreadLocal();
    private static final Map<String, Template> TEMPLATE_CACHE = new HashMap<String, Template>();

    private FreemarkerUtils(Class<?> sourceClass, String templatePath) {
        this.configuration = new Configuration(Configuration.VERSION_2_3_22);
        this.prefix = sourceClass.getName() + ":";
        this.configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(sourceClass, templatePath));
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.configuration.setCacheStorage((CacheStorage)NullCacheStorage.INSTANCE);
    }

    public static FreemarkerUtils build(Class<?> sourceClass, String templatePath) {
        log.debug("The template path is: {}", (Object)templatePath);
        return new FreemarkerUtils(sourceClass, templatePath);
    }

    public FreemarkerUtils setTemplate(String templateName) {
        try {
            String cacheKey = this.prefix + templateName;
            Template template = TEMPLATE_CACHE.get(cacheKey);
            if (template == null) {
                template = this.configuration.getTemplate(templateName);
                TEMPLATE_CACHE.put(cacheKey, template);
            }
            this.currentTemplate.set(template);
            return this;
        }
        catch (IOException e) {
            log.error("Get template has error! The template name is : " + templateName, (Throwable)e);
            throw new BaseException("Get template has error! The template name is : " + templateName, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public String generate(Object model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void generate(Object model, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.generate(model, fos);
        }
        catch (IOException e) {
            log.error("Create a file output stream exception!", (Throwable)e);
            throw new BaseException("Create a file output stream exception!", (Throwable)e);
        }
    }

    public void generate(Object model, OutputStream outputStream) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "utf-8"), 10240);){
            this.generate(model, writer);
        }
        catch (IOException e) {
            log.error("Create a buffered writer exception!", (Throwable)e);
            throw new BaseException("Create a buffered writer exception!", (Throwable)e);
        }
    }

    public void generate(Object model, BufferedWriter writer) {
        try {
            Template current = this.currentTemplate.get();
            if (current == null) {
                throw new BaseException("Current Template is null!");
            }
            current.process(model, (Writer)writer);
            writer.flush();
        }
        catch (TemplateException | IOException e) {
            log.error("Template rendering exception!", e);
            throw new BaseException("Template rendering exception!", e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

