/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.constants.Constants;

public abstract class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    private static final ZoneId ZONE = ZoneId.systemDefault();

    public static String formatMsecDate(Date date) {
        if (date != null) {
            return Constants.MSEC_DATE_FORMATTER.format(date);
        }
        return null;
    }

    public static String formatLongDate(Date date) {
        if (date != null) {
            return Constants.LONG_DATE_FORMATTER.format(date);
        }
        return null;
    }

    public static String formatShortDate(Date date) {
        if (date != null) {
            return Constants.SHORT_DATE_FORMATTER.format(date);
        }
        return null;
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            log.warn("the date is null!");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            log.warn("the pattern is empty!");
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            return simpleDateFormat.format(date);
        }
        catch (Exception e) {
            log.error("Format date error!", (Throwable)e);
            return null;
        }
    }

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            log.warn("the date is null!");
            return null;
        }
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.toLocalDate();
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            log.warn("the date is null!");
            return null;
        }
        Instant instant = date.toInstant();
        return LocalDateTime.ofInstant(instant, ZONE);
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (localDate == null) {
            log.warn("the localDate is null!");
            return null;
        }
        Instant instant = localDate.atStartOfDay(ZONE).toInstant();
        return Date.from(instant);
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            log.warn("the localDateTime is null!");
            return null;
        }
        Instant instant = localDateTime.atZone(ZONE).toInstant();
        return Date.from(instant);
    }
}

