/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.ReflectionUtils;

public abstract class CopyObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(CopyObjectUtil.class);

    public static <T> T copy(Object source, Class<T> target) {
        return CopyObjectUtil.copy(source, target, new HashMap<String, String>());
    }

    public static <T> T copy(Class<T> target, Map<String, Object> extra) {
        return CopyObjectUtil.copy(ReflectionUtils.newInstance(target), target, null, extra, null);
    }

    public static <T> T copy(Object source, Class<T> target, Map<String, String> rename) {
        return CopyObjectUtil.copy(source, target, rename, null, null);
    }

    public static <T> T copy(Object source, Class<T> target, List<String> skips) {
        return CopyObjectUtil.copy(source, target, null, null, skips);
    }

    public static <T> T copy(Object source, Class<T> target, Map<String, String> rename, Map<String, Object> extra, List<String> skips) {
        CopyObjectUtil.validateParameter(source, target);
        if (extra == null) {
            extra = new HashMap<String, Object>();
        }
        if (rename == null) {
            rename = new HashMap<String, String>();
        }
        if (skips == null) {
            skips = new ArrayList<String>();
        }
        try {
            CopyObjectUtil.obj2Map(source, extra, rename, skips);
            return CopyObjectUtil.setValue(target, extra);
        }
        catch (Exception e) {
            log.error("Error copying property!", (Throwable)e);
            return ReflectionUtils.newInstance(target);
        }
    }

    private static <T> T setValue(Class<T> target, Map<String, Object> extra) throws InstantiationException, IllegalAccessException {
        T result = ReflectionUtils.newInstance(target);
        Field[] fields = target.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            throw new RuntimeException("Target NO Fields!");
        }
        for (Field field : fields) {
            String fieldName = field.getName();
            Object value = extra.get(fieldName);
            if (value == null) continue;
            try {
                field.setAccessible(true);
                field.set(result, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void obj2Map(Object source, Map<String, Object> extra, Map<String, String> rename, List<String> skips) {
        Class<?> clazz = source.getClass();
        Field[] fields = clazz.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            throw new RuntimeException("Source NO Fields!");
        }
        for (Field field : fields) {
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName) || skips.contains(fieldName)) continue;
            try {
                String temp = rename.get(fieldName);
                if (temp != null && !temp.trim().isEmpty()) {
                    fieldName = temp;
                }
                field.setAccessible(true);
                Object value = field.get(source);
                if (value == null) continue;
                extra.put(fieldName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private static <T> void validateParameter(Object source, Class<T> target) {
        Objects.requireNonNull(source, "The source object must not be null");
        Objects.requireNonNull(target, "The target class must not be null");
    }
}

