/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.FileTypeUtil;
import top.lshaci.framework.utils.StreamUtils;
import top.lshaci.framework.utils.enums.FileType;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class FileUploadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    public static void verifySuffix(String filename, List<String> allowSuffixes) {
        if (StrUtil.isBlank((CharSequence)filename)) {
            throw new UtilException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(allowSuffixes)) {
            throw new UtilException("\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String suffix = filename.substring(filename.lastIndexOf(".") + 1);
        if (StrUtil.isBlank((CharSequence)suffix)) {
            throw new UtilException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
        }
        if (!allowSuffixes.contains(suffix.trim().toUpperCase()) && !allowSuffixes.contains(suffix.trim().toLowerCase())) {
            throw new UtilException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u88ab\u5141\u8bb8");
        }
    }

    public static void verifySuffix(InputStream inputStream, List<FileType> allowFileTypes) {
        if (inputStream == null) {
            throw new UtilException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(allowFileTypes)) {
            throw new UtilException("\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileType fileType = null;
        try (ByteArrayOutputStream os = StreamUtils.copyInputStream(inputStream);
             ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
            fileType = FileTypeUtil.getType(is);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u9519\u8bef", (Throwable)e);
            throw new UtilException("\u4e0a\u4f20\u6587\u4ef6\u53d1\u9001\u9519\u8bef");
        }
        if (fileType == null || !allowFileTypes.contains((Object)fileType)) {
            throw new UtilException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u88ab\u5141\u8bb8");
        }
    }

    public static void saveFile(String dir, String saveFileName, InputStream inputStream) {
        if (inputStream == null) {
            throw new UtilException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)dir)) {
            throw new UtilException("\u4fdd\u5b58\u6587\u4ef6\u7684\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)saveFileName)) {
            throw new UtilException("\u4fdd\u5b58\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File saveFile = new File(dir, saveFileName);
        if (!saveFile.getParentFile().exists()) {
            saveFile.getParentFile().mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(saveFile);){
            StreamUtils.write(inputStream, os);
        }
        catch (IOException | IllegalStateException e) {
            log.error("Failed to save file!", (Throwable)e);
            throw new UtilException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25", e);
        }
    }
}

