/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils.string;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.ClassUtils;
import top.lshaci.framework.utils.ReflectionUtils;
import top.lshaci.framework.utils.exception.UtilException;
import top.lshaci.framework.utils.string.converter.StringConverter;

public class StringConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(StringConverterFactory.class);
    private Map<String, StringConverter<?>> stringConverters = new HashMap();

    private StringConverterFactory() {
    }

    public static StringConverterFactory buildDefaultFactory() {
        return StringConverterFactory.buildDefaultFactory(StringConverter.class.getPackage().getName());
    }

    public static StringConverterFactory buildDefaultFactory(String packageName) {
        if (StrUtil.isEmpty((CharSequence)packageName)) {
            return StringConverterFactory.buildDefaultFactory();
        }
        String defaultPackage = StringConverter.class.getPackage().getName();
        Set<Class<?>> classSet = ClassUtils.getClassSet(packageName, false);
        if (!defaultPackage.equals(packageName)) {
            classSet.addAll(ClassUtils.getClassSet(defaultPackage, false));
        }
        if (CollectionUtil.isEmpty(classSet)) {
            String msg = "This package is not has any string converter! --> " + packageName;
            log.error(msg);
            throw new UtilException(msg);
        }
        Map<String, StringConverter> stringConverters = classSet.stream().filter(c -> !c.isInterface()).filter(c -> StringConverter.class.isAssignableFrom((Class<?>)c)).collect(Collectors.toMap(c -> ClassUtils.getInterfaceGenericType(c).getSimpleName().toLowerCase(), c -> (StringConverter)ReflectionUtils.newInstance(c)));
        StringConverterFactory factory = new StringConverterFactory();
        factory.stringConverters = stringConverters;
        return factory;
    }

    public <T> StringConverter<T> getConverter(Class<T> targetClass) {
        StringConverter<?> stringConverter;
        Objects.requireNonNull(targetClass, "The target class must not be null!");
        String key = targetClass.getSimpleName().toLowerCase();
        if ("int".equals(key)) {
            key = Integer.class.getSimpleName().toLowerCase();
        }
        if ((stringConverter = this.stringConverters.get(key)) == null) {
            log.warn("The string converter is not exist of type " + key);
        }
        return stringConverter;
    }
}

