/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils.string.converter;

import cn.hutool.core.util.StrUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.constants.Constants;
import top.lshaci.framework.utils.string.converter.StringConverter;

public class String2DateConverter
implements StringConverter<Date> {
    private static final Logger log = LoggerFactory.getLogger(String2DateConverter.class);

    @Override
    public Date convert(String source) {
        log.debug("The string is : " + source);
        if (StrUtil.isBlank((CharSequence)source)) {
            return null;
        }
        source = this.trimSource(source);
        try {
            if (source.contains("-")) {
                if (source.contains(":")) {
                    if (source.contains(".")) {
                        return Constants.MSEC_DATE_FORMATTER.parse(source);
                    }
                    return Constants.LONG_DATE_FORMATTER.parse(source);
                }
                return Constants.SHORT_DATE_FORMATTER.parse(source);
            }
            if (source.matches("^\\d+$")) {
                Long date = new Long(source);
                return new Date(date);
            }
        }
        catch (Exception e) {
            log.warn("Parse string to date is error!  --> " + source, (Throwable)e);
        }
        return null;
    }
}

