package top.lshaci.framework.utils;

import cn.hutool.core.collection.CollectionUtil;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

/**
 * <p>公共的工具</p><br>
 *
 * @author lshaci
 * @since 1.0.8
 */
public class CommonUtils {

    /**
     * 获取上一个和下一个
     *
     * @param current 当前值
     * @param all     所有的值
     * @param <T>     类型
     * @return 数组{上一个, 下一个}
     */
    public static <T> T[] goOn(T current, List<T> all) {
        T[] result = (T[]) Array.newInstance(current.getClass(), 2);
        if (Objects.isNull(current) || CollectionUtil.isEmpty(all)) {
            return result;
        }

        T next, pre = null;
        Iterator<T> iterator = all.iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (Objects.equals(current, next)) {
                result[0] = pre;
                if (iterator.hasNext()) {
                    result[1] = iterator.next();
                }
                break;
            }
            pre = next;
        }

        return result;
    }

}
