package top.lshaci.framework.utils.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * UtilErrorInfo
 *
 * @author lshaci
 * @since 1.1.0
 */
@Getter
@AllArgsConstructor
public enum UtilErrorInfo implements ErrorInfo {

    /**
     * class not found
     */
    class_not_found(501_0_01, "类未找到, 类名: {}"),
    /**
     * class no generic type
     */
    class_no_generic_type(501_0_02, "类不存在泛型类型, 类名: {}"),
    /**
     * package name is blank
     */
    package_name_is_blank(501_0_03, "包名为空"),
    /**
     * file read failure
     */
    file_read_failure(501_0_04, "文件读取失败"),
    /**
     * file name is blank
     */
    file_name_is_blank(501_0_05, "文件名为空"),
    /**
     * file allow type is empty
     */
    file_allow_suffix_is_empty(501_0_06, "允许的文件类型为空"),
    /**
     * file suffix is blank
     */
    file_suffix_is_blank(501_0_07, "上传文件类型错误"),
    /**
     * file suffix not allow
     */
    file_suffix_not_allow(501_0_08, "文件类型 {} 不被允许"),
    /**
     * file is null
     */
    file_is_null(501_0_09, "文件为空"),
    /**
     * file save path is blank
     */
    file_save_path_is_blank(501_0_10, "保存文件的路径为空"),
    /**
     * file save name is blank
     */
    file_save_name_is_blank(501_0_11, "保存文件名为空"),
    /**
     * file upload failure
     */
    file_upload_failure(501_0_12, "上传文件失败"),
    /**
     * file save failure
     */
    file_save_failure(501_0_13, "保存文件失败"),
    /**
     * package not has string converter
     */
    package_not_has_string_converter(501_0_14, "包下未找到字符串转换器, 包名: {}"),
    ;
    /**
     * 异常码
     */
    private final int code;
    /**
     * 异常信息
     */
    private final String msg;
}
