/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.lshaci.framework.utils.enums.UtilErrorInfo;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class ClassUtils {
    private static final Log log = LogFactory.get(ClassUtils.class);

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        try {
            return Class.forName(className, isInitialized, ClassUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error((Throwable)e, UtilErrorInfo.class_not_found.getMsg(), new Object[]{className});
            throw new UtilException(UtilErrorInfo.class_not_found, className);
        }
    }

    public static Class<?> getInterfaceGenericType(Class<?> clazz) {
        return ClassUtils.getInterfaceGenericType(clazz, 0, 0);
    }

    public static Class<?> getInterfaceGenericType(Class<?> clazz, int interfaceIndex, int genericTypeIndex) {
        Objects.requireNonNull(clazz, "The class is must not be null!");
        Type[] interfaces = clazz.getGenericInterfaces();
        Type type = interfaces[interfaceIndex];
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[genericTypeIndex];
        }
        throw new UtilException(UtilErrorInfo.class_no_generic_type, clazz.getSimpleName());
    }

    public static Set<Class<?>> getClassSet(String packageName, boolean isRecursion) {
        if (StrUtil.isBlank((CharSequence)packageName)) {
            throw new UtilException(UtilErrorInfo.package_name_is_blank, new Object[0]);
        }
        HashSet classSet = new HashSet();
        String packagePath = packageName.replace(".", "/");
        try {
            Enumeration<URL> urls = ClassUtils.getClassLoader().getResources(packagePath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String path = url.getPath().replaceAll("%20", " ");
                    ClassUtils.addClassFromFile(classSet, path, packageName, isRecursion);
                    continue;
                }
                if ("jar".equals(protocol)) {
                    JarFile jarFile;
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    if (jarURLConnection == null || (jarFile = jarURLConnection.getJarFile()) == null) continue;
                    ClassUtils.addClassFromJar(classSet, jarFile.entries(), packageName, isRecursion);
                    jarFile.close();
                    continue;
                }
                ClassUtils.addClassNameFromJars(classSet, ((URLClassLoader)ClassUtils.getClassLoader()).getURLs(), packageName, isRecursion);
            }
        }
        catch (IOException e) {
            log.error("Get class set is error, the package is " + packageName, new Object[]{e});
        }
        return classSet;
    }

    private static void addClassNameFromJars(Set<Class<?>> classSet, URL[] urls, String packageName, boolean isRecursion) throws IOException {
        for (int i = 0; i < urls.length; ++i) {
            String classPath = urls[i].getPath();
            if (classPath.endsWith("classes/")) continue;
            JarFile jarFile = new JarFile(classPath.substring(classPath.indexOf("/")));
            ClassUtils.addClassFromJar(classSet, jarFile.entries(), packageName, isRecursion);
            jarFile.close();
        }
    }

    private static void addClassFromJar(Set<Class<?>> classSet, Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith(".class")) continue;
            String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
            if (isRecursion) {
                ClassUtils.doAddClass(classSet, className);
                continue;
            }
            if (className.replace(packageName + ".", "").contains(".")) continue;
            ClassUtils.doAddClass(classSet, className);
        }
    }

    private static void addClassFromFile(Set<Class<?>> classSet, String packagePath, String packageName, boolean isRecursion) {
        File[] files = new File(packagePath).listFiles(f -> f.isFile() && f.getName().endsWith(".class") || isRecursion && f.isDirectory());
        if (files != null && files.length > 0) {
            for (File file : files) {
                String fileName = file.getName();
                if (file.isFile()) {
                    String className = fileName.substring(0, fileName.lastIndexOf("."));
                    if (StrUtil.isNotBlank((CharSequence)packageName)) {
                        className = packageName + "." + className;
                    }
                    ClassUtils.doAddClass(classSet, className);
                    continue;
                }
                if (!isRecursion || !file.isDirectory()) continue;
                String subPackagePath = fileName;
                if (StrUtil.isNotBlank((CharSequence)packagePath)) {
                    subPackagePath = packagePath + "/" + subPackagePath;
                }
                String subPackageName = fileName;
                if (StrUtil.isNotBlank((CharSequence)packageName)) {
                    subPackageName = packageName + "/" + subPackageName;
                }
                ClassUtils.addClassFromFile(classSet, subPackagePath, subPackageName, isRecursion);
            }
        }
    }

    private static void doAddClass(Set<Class<?>> classSet, String className) {
        Class<?> clazz = ClassUtils.loadClass(className, false);
        classSet.add(clazz);
    }
}

