/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ContinuousDateData {
    public static <R> List<R> day(LocalDate startDate, LocalDate endDate, Function<String, ? extends R> mapper) {
        return Stream.iterate(startDate, s -> s.plusDays(1L)).limit(startDate.until(endDate, ChronoUnit.DAYS)).map(LocalDate::toString).map(mapper).collect(Collectors.toList());
    }

    public static <R> List<R> week(LocalDate startDate, LocalDate endDate, Function<LocalDate, ? extends R> mapper) {
        return ContinuousDateData.week(startDate, endDate, mapper, DayOfWeek.MONDAY);
    }

    public static <R> List<R> week(LocalDate startDate, LocalDate endDate, Function<LocalDate, ? extends R> mapper, DayOfWeek dayOfWeek) {
        LocalDate startWeek = startDate.with(WeekFields.ISO.dayOfWeek(), dayOfWeek.getValue());
        LocalDate endWeek = endDate.with(WeekFields.ISO.dayOfWeek(), dayOfWeek.getValue());
        return Stream.iterate(startWeek, s -> s.plusWeeks(1L)).limit(startWeek.until(endWeek, ChronoUnit.WEEKS)).map(mapper).collect(Collectors.toList());
    }

    public static <R> List<R> month(LocalDate startDate, LocalDate endDate, Function<String, ? extends R> mapper) {
        YearMonth startMonth = YearMonth.of(startDate.getYear(), startDate.getMonth());
        return Stream.iterate(0, i -> i + 1).limit(startDate.until(endDate, ChronoUnit.MONTHS)).map(startMonth::plusMonths).map(YearMonth::toString).map(mapper).collect(Collectors.toList());
    }
}

