/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.FileTypeUtil;
import top.lshaci.framework.utils.enums.FileType;
import top.lshaci.framework.utils.enums.UtilErrorInfo;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class FileUploadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    public static void verifySuffix(String filename, List<String> allowSuffixes) {
        if (StrUtil.isBlank((CharSequence)filename)) {
            throw new UtilException(UtilErrorInfo.file_name_is_blank, new Object[0]);
        }
        if (CollectionUtil.isEmpty(allowSuffixes)) {
            throw new UtilException(UtilErrorInfo.file_allow_suffix_is_empty, new Object[0]);
        }
        String suffix = filename.substring(filename.lastIndexOf(".") + 1);
        if (StrUtil.isBlank((CharSequence)suffix)) {
            throw new UtilException(UtilErrorInfo.file_suffix_is_blank, new Object[0]);
        }
        if (!allowSuffixes.contains(suffix.trim().toUpperCase()) && !allowSuffixes.contains(suffix.trim().toLowerCase())) {
            throw new UtilException(UtilErrorInfo.file_suffix_not_allow, suffix);
        }
    }

    public static void verifySuffix(InputStream inputStream, List<FileType> allowFileTypes) {
        FileType fileType;
        if (inputStream == null) {
            throw new UtilException(UtilErrorInfo.file_is_null, new Object[0]);
        }
        if (CollectionUtil.isEmpty(allowFileTypes)) {
            throw new UtilException(UtilErrorInfo.file_allow_suffix_is_empty, new Object[0]);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IoUtil.copy((InputStream)inputStream, (OutputStream)os);
        try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
            fileType = FileTypeUtil.getType(is);
        }
        catch (Exception e) {
            log.error(UtilErrorInfo.file_upload_failure.getMsg(), (Throwable)e);
            throw new UtilException(UtilErrorInfo.file_upload_failure, new Object[0]);
        }
        if (fileType == null || !allowFileTypes.contains((Object)fileType)) {
            throw new UtilException(UtilErrorInfo.file_suffix_not_allow, new Object[]{fileType});
        }
    }

    public static void saveFile(String dir, String saveFileName, InputStream inputStream) {
        if (inputStream == null) {
            throw new UtilException(UtilErrorInfo.file_is_null, new Object[0]);
        }
        if (StrUtil.isBlank((CharSequence)dir)) {
            throw new UtilException(UtilErrorInfo.file_save_path_is_blank, new Object[0]);
        }
        if (StrUtil.isBlank((CharSequence)saveFileName)) {
            throw new UtilException(UtilErrorInfo.file_save_name_is_blank, new Object[0]);
        }
        File saveFile = new File(dir, saveFileName);
        if (!saveFile.getParentFile().exists()) {
            saveFile.getParentFile().mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(saveFile);){
            IoUtil.copy((InputStream)inputStream, (OutputStream)os);
        }
        catch (IOException | IllegalStateException e) {
            log.error(UtilErrorInfo.file_save_failure.getMsg(), (Throwable)e);
            throw new UtilException(UtilErrorInfo.file_save_failure, new Object[0]);
        }
    }
}

