/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import cn.hutool.core.collection.CollUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HierarchyUtil {
    public <T, K> List<T> setChildren(List<T> data, K topKey, Function<T, K> getKey, Function<T, K> getParentKey, BiConsumer<T, List<T>> setChildren, Comparator<T> comparator) {
        if (CollUtil.isEmpty(data)) {
            return Collections.emptyList();
        }
        Map<K, List<T>> dataMap = data.stream().collect(Collectors.groupingBy(getParentKey));
        List top = dataMap.get(topKey).stream().sorted(comparator).collect(Collectors.toList());
        if (CollUtil.isEmpty(top)) {
            return Collections.emptyList();
        }
        HierarchyUtil.setChildren(top, dataMap, getKey, setChildren, comparator);
        return top;
    }

    public static <T, K> void setChildren(List<T> top, Map<K, List<T>> dataMap, Function<T, K> getKey, BiConsumer<T, List<T>> setChildren, Comparator<? super T> comparator) {
        for (T t : top) {
            K key = getKey.apply(t);
            List<T> children = dataMap.get(key);
            if (!CollUtil.isNotEmpty(children)) continue;
            children = children.stream().sorted(comparator).collect(Collectors.toList());
            setChildren.accept(t, children);
            HierarchyUtil.setChildren(children, dataMap, getKey, setChildren, comparator);
        }
    }
}

