/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils.string.converter;

import cn.hutool.core.util.StrUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.constants.Constants;
import top.lshaci.framework.utils.string.converter.StringConverter;

public class String2LocalDateConverter
implements StringConverter<LocalDate> {
    private static final Logger log = LoggerFactory.getLogger(String2LocalDateConverter.class);

    @Override
    public LocalDate convert(String source) {
        log.debug("The string is : " + source);
        if (StrUtil.isBlank((CharSequence)source)) {
            return null;
        }
        source = this.trimSource(source);
        try {
            if (source.contains("-")) {
                if (source.contains(":")) {
                    if (source.contains(".")) {
                        return LocalDate.parse(source, Constants.MSEC_DATE_TIME_FORMATTER);
                    }
                    return LocalDate.parse(source, Constants.LONG_DATE_TIME_FORMATTER);
                }
                return LocalDate.parse(source, Constants.SHORT_DATE_TIME_FORMATTER);
            }
            if (source.matches("^\\d+$")) {
                Long timeMillis = Long.valueOf(source);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), ZoneId.systemDefault()).toLocalDate();
            }
        }
        catch (Exception e) {
            log.warn("Parse string to local date is error!  --> " + source, (Throwable)e);
        }
        return null;
    }
}

