/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.common.utils;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpRequestUtils {
    public static HttpServletRequest get() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        Objects.requireNonNull(request, "The http request is null!");
        return request;
    }

    public static void setAttribute(String key, Object value) {
        HttpServletRequest request = HttpRequestUtils.get();
        request.setAttribute(key, value);
    }

    public static Object getAttribute(String key) {
        HttpServletRequest request = HttpRequestUtils.get();
        return request.getAttribute(key);
    }

    public static void removeAttribute(String key) {
        HttpServletRequest request = HttpRequestUtils.get();
        request.removeAttribute(key);
    }

    public static String getIp() {
        HttpServletRequest request = HttpRequestUtils.get();
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

