/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.helper.aspect;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import top.lshaci.framework.web.common.utils.HttpRequestUtils;
import top.lshaci.framework.web.common.utils.HttpSessionUtils;
import top.lshaci.framework.web.helper.exception.RepeatSubmitException;
import top.lshaci.framework.web.helper.service.PreventRepeat;

@Aspect
@Order(value=2)
public class PreventRepeatSubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(PreventRepeatSubmitAspect.class);
    private static ReentrantLock lock = new ReentrantLock();
    private final PreventRepeat preventRepeat;

    @Pointcut(value="@annotation(top.lshaci.framework.web.helper.annotation.PreventRepeatSubmit)")
    public void preventRepeatSubmit() {
    }

    @Before(value="preventRepeatSubmit()")
    public void doBefore() {
        String submitKey = this.submitKey();
        log.debug("PreventRepeatSubmitAspect: the submit key is: {}.", (Object)submitKey);
        try {
            lock.lock();
            String value = this.preventRepeat.getAndSet(submitKey);
            if (Objects.nonNull(value)) {
                log.warn("In operation...");
                throw new RepeatSubmitException();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @AfterReturning(value="preventRepeatSubmit()")
    public void doAfterReturning() {
        String submitKey = this.submitKey();
        this.preventRepeat.remove(submitKey);
        log.debug("Remove the submit key: {}.", (Object)submitKey);
    }

    @AfterThrowing(value="preventRepeatSubmit()", throwing="e")
    public void doAfterThrowing(Exception e) {
        if (e instanceof RepeatSubmitException) {
            log.warn("In operation...");
            return;
        }
        String submitKey = this.submitKey();
        this.preventRepeat.remove(submitKey);
        log.debug("Remove the submit key: {}.", (Object)submitKey);
    }

    private String submitKey() {
        return HttpSessionUtils.get().getId() + ":" + HttpRequestUtils.get().getMethod() + ":" + HttpRequestUtils.get().getRequestURI();
    }

    public PreventRepeatSubmitAspect(PreventRepeat preventRepeat) {
        this.preventRepeat = preventRepeat;
    }
}

