/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.helper.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.lshaci.framework.web.helper.aspect.PreventRepeatSubmitAspect;
import top.lshaci.framework.web.helper.properties.FrameworkWebHelperProperties;
import top.lshaci.framework.web.helper.service.PreventRepeat;
import top.lshaci.framework.web.helper.service.impl.RedisPreventRepeat;
import top.lshaci.framework.web.helper.service.impl.TimedCachePreventRepeat;

@Configuration
@EnableConfigurationProperties(value={FrameworkWebHelperProperties.class})
public class FrameworkWebHelperConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkWebHelperConfig.class);
    @Autowired
    private FrameworkWebHelperProperties properties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.web.helper.prevent-repeat-submit.enabled"}, havingValue="true", matchIfMissing=true)
    public PreventRepeatSubmitAspect preventRepeatSubmitAspect(PreventRepeat preventRepeat) {
        log.debug("Config prevent repeat submit aspect...");
        return new PreventRepeatSubmitAspect(preventRepeat);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={StringRedisTemplate.class})
    public PreventRepeat redisPreventRepeat(StringRedisTemplate stringRedisTemplate) {
        log.debug("Config redis prevent repeat...");
        return new RedisPreventRepeat(this.properties.getPreventRepeatSubmit().getTimeout(), stringRedisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={StringRedisTemplate.class})
    public PreventRepeat timedCachePreventRepeat() {
        log.debug("Config timed cache prevent repeat...");
        return new TimedCachePreventRepeat(this.properties.getPreventRepeatSubmit().getTimeout());
    }
}

