/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.handler.exception;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import top.lshaci.framework.common.exception.BaseException;
import top.lshaci.framework.web.enums.ErrorCode;
import top.lshaci.framework.web.model.JsonResponse;

@ConditionalOnProperty(value={"globalExceptionHandler.enabled"}, havingValue="true", matchIfMissing=false)
@RestController
@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public JsonResponse baseExceptionHandler(HttpServletRequest req, Exception e) {
        log.error("System be happend exception!", (Throwable)e);
        JsonResponse result = new JsonResponse();
        result.setStatus(false);
        result.setCode(ErrorCode.INTERNAL_PROGRAM_ERROR.getCode());
        result.setMessage(e.getMessage());
        return result;
    }

    @ExceptionHandler(value={Exception.class})
    public JsonResponse defaultExceptionHandler(HttpServletRequest req, Exception e) {
        log.error("System be happend exception!", (Throwable)e);
        ErrorCode errorCode = ErrorCode.getByException(e);
        JsonResponse result = new JsonResponse();
        result.setStatus(false);
        result.setCode(errorCode.getCode());
        result.setMessage(errorCode.getMsg());
        return result;
    }
}

