/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpRequestUtils {
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        Objects.requireNonNull(request, "The http request is null!");
        return request;
    }

    public static void setRequestAttribute(String name, Object value) {
        HttpServletRequest request = HttpRequestUtils.getRequest();
        request.setAttribute(name, value);
    }

    public static Object getRequestAttribute(String name) {
        HttpServletRequest request = HttpRequestUtils.getRequest();
        return request.getAttribute(name);
    }

    public static HttpSession getSession() {
        HttpSession session = HttpRequestUtils.getRequest().getSession();
        Objects.requireNonNull(session, "The http session is null!");
        return session;
    }

    public static void setSessionAttribute(String name, Object value) {
        HttpSession session = HttpRequestUtils.getSession();
        session.setAttribute(name, value);
    }

    public static Object getSessionAttribute(String name) {
        HttpSession session = HttpRequestUtils.getSession();
        return session.getAttribute(name);
    }
}

