/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.enums;

public enum ErrorCode {
    LOGIN_EXCEPTION(40001, "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", "top.lshaci.framework.web.exception.LoginException"),
    ROLE_PERMISSION_EXCEPTION(40002, "\u65e0\u6743\u9650\u8fdb\u884c\u6b64\u64cd\u4f5c", "top.lshaci.framework.web.exception.RolePermissionException"),
    REPEAT_SUBMIT_EXCEPTION(40003, "\u4e0a\u6b21\u64cd\u4f5c\u672a\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", "top.lshaci.framework.web.exception.RepeatSubmitException"),
    INTERNAL_PROGRAM_ERROR(50000, "\u7a0b\u5e8f\u5185\u90e8\u9519\u8bef\uff0c\u64cd\u4f5c\u5931\u8d25", "top.lshaci.framework.common.exception.BaseException"),
    DATA_ACCESS_EXCEPTION(50001, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25", "org.springframework.dao.DataAccessException"),
    COMMUNICATIONS_EXCEPTION(50002, "\u6570\u636e\u5e93\u8fde\u63a5\u4e2d\u65ad", "com.mysql.jdbc.CommunicationsException"),
    DATA_INTEGRITY_VIOLATION_EXCEPTION(50003, "\u6570\u636e\u5f02\u5e38, \u64cd\u4f5c\u5931\u8d25", "org.springframework.dao.DataIntegrityViolationException"),
    MYSQL_INTEGRITY_CONSTRAINT_VIOLATION_EXCEPTION(50004, "\u6570\u636e\u5f02\u5e38, \u64cd\u4f5c\u5931\u8d25", "com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException"),
    NULL_POINTER_EXCEPTION(50005, "\u5bf9\u8c61\u672a\u7ecf\u521d\u59cb\u5316\u6216\u4e0d\u5b58\u5728", "java.lang.NullPointerException"),
    IO_EXCEPTION(50006, "IO\u5f02\u5e38", "java.io.IOException"),
    CLASS_NOT_FOUND_EXCEPTION(50007, "\u6307\u5b9a\u7684\u7c7b\u4e0d\u5b58\u5728", "java.lang.ClassNotFoundException"),
    ARITHMETIC_EXCEPTION(50008, "\u6570\u5b66\u8fd0\u7b97\u5f02\u5e38", "java.lang.ArithmeticException"),
    ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION(50009, "\u6570\u7ec4\u4e0b\u6807\u8d8a\u754c", "java.lang.ArrayIndexOutOfBoundsException"),
    ILLEGAL_ARGUMENT_EXCEPTION(50010, "\u53c2\u6570\u9519\u8bef\u6216\u975e\u6cd5", "java.lang.IllegalArgumentException"),
    CLASS_CAST_EXCEPTION(50011, "\u7c7b\u578b\u5f3a\u5236\u8f6c\u6362\u9519\u8bef", "java.lang.ClassCastException"),
    SQL_EXCEPTION(50013, "\u64cd\u4f5c\u6570\u636e\u5e93\u5f02\u5e38", "java.sql.SQLException"),
    SECURITY_EXCEPTION(50012, "\u8fdd\u80cc\u5b89\u5168\u539f\u5219\u5f02\u5e38", "java.lang.SecurityException"),
    NOSUCH_METHOD_EXCEPTION(50014, "\u65b9\u6cd5\u672a\u627e\u5230\u5f02\u5e38", "java.lang.NoSuchMethodException"),
    CONNECT_EXCEPTION(50016, "\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38", "java.net.ConnectException"),
    CANCELLATION_EXCEPTION(50017, "\u4efb\u52a1\u5df2\u88ab\u53d6\u6d88\u7684\u5f02\u5e38", "java.util.concurrent.CancellationException"),
    PARSE_EXCEPTION(50019, "\u65e5\u671f\u683c\u5f0f\u9519\u8bef", "java.text.ParseException"),
    MYSQL_DATA_TRUNCATION_EXCEPTION(50020, "\u670d\u52a1\u5668\u4e0d\u80fd\u63a5\u6536\u6240\u6709\u6570\u636e", "com.mysql.jdbc.MysqlDataTruncation"),
    HTTP_MESSAGE_NOT_READABLE_EXCEPTION(50021, "\u53c2\u6570\u8f6c\u6362\u5f02\u5e38", "org.springframework.http.converter.HttpMessageNotReadableException"),
    HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION(50022, "\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301", "org.springframework.web.HttpRequestMethodNotSupportedException");

    private int code;
    private String msg;
    private String exceptionClass;

    private ErrorCode(int code, String msg, String exceptionClass) {
        this.code = code;
        this.msg = msg;
        this.exceptionClass = exceptionClass;
    }

    public static ErrorCode getByException(Exception exception) {
        if (exception != null) {
            ErrorCode[] errorCodes;
            for (ErrorCode errorCode : errorCodes = ErrorCode.values()) {
                if (!exception.getClass().getName().equals(errorCode.exceptionClass)) continue;
                return errorCode;
            }
        }
        return INTERNAL_PROGRAM_ERROR;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }
}

