/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import top.lshaci.framework.web.enums.ErrorCode;
import top.lshaci.framework.web.model.JsonResponse;
import top.lshaci.framework.web.utils.HttpResponseUtils;
import top.lshaci.framework.web.utils.SessionUserUtils;

public abstract class AbstractLoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginInterceptor.class);
    private String redirectUrl;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.debug("LoginInterceptor: " + request.getRequestURI());
        if (!(handler instanceof HandlerMethod)) {
            log.warn("This request does not access controller!");
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        if ("springfox.documentation.swagger.web.ApiResourceController".equals(handlerMethod.getBeanType().getName())) {
            log.warn("This request is to access the swagger ui!");
            return true;
        }
        String loginUser = SessionUserUtils.getUserInSession();
        if (loginUser == null) {
            log.warn("Not login.");
            if (this.isAjaxRequest(request)) {
                log.info("This request is an ajax request.");
                JsonResponse jsonResponse = JsonResponse.failure(ErrorCode.LOGIN_EXCEPTION.getMsg()).setCode(ErrorCode.LOGIN_EXCEPTION.getCode()).addOtherData("redirectUrl", this.redirectUrl);
                log.warn("No login, response json.");
                HttpResponseUtils.responseJson(jsonResponse);
            } else {
                log.warn("No login, redirect home page.");
                response.sendRedirect(this.redirectUrl);
            }
            return false;
        }
        log.debug("Already login.");
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public AbstractLoginInterceptor setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    protected abstract boolean isAjaxRequest(HttpServletRequest var1);
}

