/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.aspect;

import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import top.lshaci.framework.web.exception.RepeatSubmitException;
import top.lshaci.framework.web.utils.HttpRequestUtils;
import top.lshaci.framework.web.utils.HttpSessionUtils;

@Aspect
@Order(value=2)
public class PreventRepeatSubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(PreventRepeatSubmitAspect.class);
    private static final String SUBMIT_KEY_PREFIX = PreventRepeatSubmitAspect.class.getSimpleName() + "_";
    private static final String IN_OPERATION = "IN_OPERATION";

    @Pointcut(value="@annotation(top.lshaci.framework.web.annotation.PreventRepeatSubmit)")
    public void preventRepeatSubmit() {
    }

    @Before(value="preventRepeatSubmit()")
    public void doBefore() {
        String requestUrl = HttpRequestUtils.get().getRequestURI();
        log.debug("PreventRepeatSubmitAspect: the request url is: {}.", (Object)requestUrl);
        String submitKey = this.concatSubmitKey();
        Object value = HttpSessionUtils.getAttribute(this.concatSubmitKey());
        if (value != null) {
            log.warn("In operation...");
            throw new RepeatSubmitException();
        }
        HttpSessionUtils.setAttribute(submitKey, IN_OPERATION);
    }

    @AfterReturning(value="preventRepeatSubmit()")
    public void doAfterReturning() {
        HttpSessionUtils.removeAttribute(this.concatSubmitKey());
        log.debug("Remove submit token key from session is succeed.");
    }

    @AfterThrowing(value="preventRepeatSubmit()", throwing="e")
    public void doAfterThrowing(Exception e) {
        if (e instanceof RepeatSubmitException) {
            log.warn("In operation...");
            return;
        }
        HttpSessionUtils.removeAttribute(this.concatSubmitKey());
        log.debug("Remove submit token key from session is succeed.");
    }

    private String concatSubmitKey() {
        return SUBMIT_KEY_PREFIX + HttpRequestUtils.get().getRequestURI();
    }
}

