/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.aspect;

import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import top.lshaci.framework.web.annotation.IgnoreRole;
import top.lshaci.framework.web.annotation.NeedRole;
import top.lshaci.framework.web.exception.RolePermissionException;
import top.lshaci.framework.web.utils.HttpRequestUtils;
import top.lshaci.framework.web.utils.SessionUserUtils;

@Aspect
@Order(value=3)
public class UserRoleAspect {
    private static final Logger log = LoggerFactory.getLogger(UserRoleAspect.class);

    @Pointcut(value="@within(top.lshaci.framework.web.annotation.NeedRole) || @annotation(top.lshaci.framework.web.annotation.NeedRole) ")
    public void userRole() {
    }

    @Before(value="userRole()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        String[] needRoles;
        Optional<String> optional;
        HttpServletRequest request = HttpRequestUtils.get();
        String requestUrl = request.getRequestURI();
        log.debug("The request url is: {}.", (Object)requestUrl);
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        IgnoreRole ignoreRole = signature.getMethod().getAnnotation(IgnoreRole.class);
        if (ignoreRole != null) {
            log.debug("This method does not require role control: {}", (Object)signature.getName());
            return;
        }
        String userRole = SessionUserUtils.getUserRoleInSession();
        if (StringUtils.isBlank((CharSequence)userRole)) {
            throw new RolePermissionException();
        }
        Class controllerClass = signature.getDeclaringType();
        NeedRole classNeedRole = controllerClass.getAnnotation(NeedRole.class);
        NeedRole needRole = signature.getMethod().getAnnotation(NeedRole.class);
        if (needRole == null) {
            needRole = classNeedRole;
        }
        if (!(optional = Arrays.stream(needRoles = needRole.value()).filter(r -> userRole.equalsIgnoreCase((String)r)).findFirst()).isPresent()) {
            throw new RolePermissionException();
        }
    }
}

