/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.common.exception.BaseException;
import top.lshaci.framework.utils.StreamUtils;
import top.lshaci.framework.web.enums.ResponseContentType;
import top.lshaci.framework.web.exception.WebBaseException;

public class DownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtils.class);

    public static void download(String downloadName, ResponseContentType contentType, ByteArrayOutputStream outputStream, HttpServletResponse response) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
             ServletOutputStream os = response.getOutputStream();){
            DownloadUtils.writeFile(downloadName, contentType, response, is, os);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", (Throwable)e);
            throw new WebBaseException("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", e);
        }
    }

    public static void download(String downloadName, ResponseContentType contentType, FileInputStream is, HttpServletResponse response) {
        try (ServletOutputStream os = response.getOutputStream();){
            DownloadUtils.writeFile(downloadName, contentType, response, is, os);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", (Throwable)e);
            throw new WebBaseException("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", e);
        }
    }

    public static void download(String downloadName, ResponseContentType contentType, String filePath, HttpServletResponse response) {
        try (FileInputStream is = new FileInputStream(filePath);
             ServletOutputStream os = response.getOutputStream();){
            DownloadUtils.writeFile(downloadName, contentType, response, is, os);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", (Throwable)e);
            throw new WebBaseException("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", e);
        }
    }

    private static void writeFile(String downloadName, ResponseContentType contentType, HttpServletResponse response, InputStream is, ServletOutputStream os) throws IOException {
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(downloadName, "UTF-8"));
        if (StringUtils.isBlank((CharSequence)downloadName)) {
            throw new BaseException("The download file name must not be empty!");
        }
        if (contentType != null) {
            response.setContentType(contentType.getName());
        }
        StreamUtils.write((InputStream)is, (OutputStream)os);
    }
}

