/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.config;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import top.lshaci.framework.web.aspect.PreventRepeatSubmitAspect;
import top.lshaci.framework.web.aspect.UserRoleAspect;
import top.lshaci.framework.web.aspect.WebLogAspect;
import top.lshaci.framework.web.exception.handler.GlobalExceptionHandler;
import top.lshaci.framework.web.model.ExceptionMessage;
import top.lshaci.framework.web.properties.FrameworkWebProperties;
import top.lshaci.framework.web.utils.GlobalExceptionUtils;

@Configuration
@EnableConfigurationProperties(value={FrameworkWebProperties.class})
public class FrameworkWebConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkWebConfig.class);
    @Autowired
    private FrameworkWebProperties properties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.web.enabled.global-exception-handler"}, havingValue="true", matchIfMissing=true)
    public GlobalExceptionHandler globalExceptionHandler() {
        log.debug("Config global exception handler...");
        List<ExceptionMessage> exceptionMessages = this.properties.getExceptionMessages();
        if (!CollectionUtils.isEmpty(exceptionMessages)) {
            GlobalExceptionUtils.putAll(exceptionMessages);
        }
        return new GlobalExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.web.enabled.web-log"}, havingValue="true")
    public WebLogAspect webLogAspect() {
        log.debug("Config web log aspect...");
        return new WebLogAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.web.enabled.prevent-repeat-submit"}, havingValue="true", matchIfMissing=true)
    public PreventRepeatSubmitAspect preventRepeatSubmitAspect() {
        log.debug("Config prevent repeat submit aspect...");
        return new PreventRepeatSubmitAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.web.enabled.user-role"}, havingValue="true", matchIfMissing=true)
    public UserRoleAspect userRoleAspect() {
        log.debug("Config user role aspect...");
        return new UserRoleAspect();
    }
}

