/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.aspect;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import top.lshaci.framework.web.common.utils.HttpRequestUtils;
import top.lshaci.framework.web.utils.SessionUserUtils;

@Aspect
@Order(value=1)
public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);
    private static final ThreadLocal<Long> START_TIME = new ThreadLocal();
    private static final ThreadLocal<String> REQUEST_CONTROLLER = new ThreadLocal();

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping)|| @annotation(org.springframework.web.bind.annotation.PutMapping)|| @annotation(org.springframework.web.bind.annotation.PatchMapping)|| @annotation(org.springframework.web.bind.annotation.DeleteMapping)|| @annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        String controllerName = joinPoint.getSignature().getDeclaringTypeName();
        REQUEST_CONTROLLER.set(controllerName);
        if ("springfox.documentation.swagger.web.ApiResourceController".equals(controllerName)) {
            return;
        }
        START_TIME.set(System.currentTimeMillis());
        HttpServletRequest request = HttpRequestUtils.get();
        String userInSession = SessionUserUtils.getUserInSession();
        log.debug("***IN*********LOGIN USER: {}", (Object)userInSession);
        log.debug("***IN*********REQUEST URL: {}", (Object)request.getRequestURL());
        log.debug("***IN*********REQUEST METHOD: {}", (Object)request.getMethod());
        log.debug("***IN*********CLIENT IP: {}", (Object)HttpRequestUtils.getIp());
        log.debug("***IN*********REQUEST CONTROLLER: {}", (Object)joinPoint.getSignature().getDeclaringTypeName());
        log.debug("***IN*********REQUEST METHOD: {}", (Object)joinPoint.getSignature().getName());
        log.debug("***IN*********ARGS: {}", (Object)Arrays.toString(joinPoint.getArgs()));
    }

    @AfterReturning(returning="ret", pointcut="webLog()")
    public void doAfterReturning(Object ret) throws Throwable {
        if ("springfox.documentation.swagger.web.ApiResourceController".equals(REQUEST_CONTROLLER.get())) {
            return;
        }
        log.debug("***OUT********RESPONSE: {}", (Object)JSON.toJSONString((Object)ret));
        log.debug("***OUT********SPEND TIME: {}", (Object)(System.currentTimeMillis() - START_TIME.get()));
    }
}

