/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import top.lshaci.framework.web.enums.ErrorCode;

public class ExceptionMessage {
    private static final Logger log = LoggerFactory.getLogger(ExceptionMessage.class);
    private int code;
    @Nullable
    private String message;
    @Nullable
    private Class<? extends Exception> exceptionClass;

    public ExceptionMessage(int code, String message, Class<? extends Exception> exceptionClass) {
        Assert.hasText((String)message, (String)"The exception message must has text!");
        Assert.notNull(exceptionClass, (String)"The exception class must not be null!");
        this.code = code;
        this.message = message;
        this.exceptionClass = exceptionClass;
    }

    public ExceptionMessage(ErrorCode errorCode) {
        Assert.notNull((Object)((Object)errorCode), (String)"The error code must not be null!");
        this.code = errorCode.getCode();
        this.message = errorCode.getMsg();
        try {
            this.exceptionClass = Class.forName(errorCode.getExceptionClass());
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found! Class name is: {}", (Object)errorCode.getExceptionClass());
        }
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Class<? extends Exception> getExceptionClass() {
        return this.exceptionClass;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public void setExceptionClass(@Nullable Class<? extends Exception> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionMessage)) {
            return false;
        }
        ExceptionMessage other = (ExceptionMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Class<? extends Exception> this$exceptionClass = this.getExceptionClass();
        Class<? extends Exception> other$exceptionClass = other.getExceptionClass();
        return !(this$exceptionClass == null ? other$exceptionClass != null : !this$exceptionClass.equals(other$exceptionClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExceptionMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Class<? extends Exception> $exceptionClass = this.getExceptionClass();
        result = result * 59 + ($exceptionClass == null ? 43 : $exceptionClass.hashCode());
        return result;
    }

    public String toString() {
        return "ExceptionMessage(code=" + this.getCode() + ", message=" + this.getMessage() + ", exceptionClass=" + this.getExceptionClass() + ")";
    }

    public ExceptionMessage() {
    }
}

