/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.web.enums.ErrorCode;
import top.lshaci.framework.web.model.ExceptionMessage;

public class GlobalExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionUtils.class);
    private static Map<Class<? extends Exception>, ExceptionMessage> exceptionMessageMap;
    private static final ExceptionMessage DEFAULT_MESSAGE;

    public static void put(ExceptionMessage exceptionMessage) {
        ExceptionMessage oldMessage = exceptionMessageMap.put(exceptionMessage.getExceptionClass(), exceptionMessage);
        if (Objects.nonNull(oldMessage)) {
            log.info("==>Exception Message Change<== old: {}, new: {}", (Object)oldMessage, (Object)exceptionMessage);
        }
    }

    public static void putAll(List<ExceptionMessage> exceptionMessages) {
        if (CollectionUtils.isEmpty(exceptionMessages)) {
            log.info("The exception message list is empty!");
        }
        exceptionMessages.forEach(m -> {
            ExceptionMessage oldMessage = exceptionMessageMap.put(m.getExceptionClass(), (ExceptionMessage)m);
            if (Objects.nonNull(oldMessage)) {
                log.info("==>Exception Message Change<== old: {}, new: {}", (Object)oldMessage, m);
            }
        });
    }

    public static ExceptionMessage get(Class<? extends Exception> exceptionClass) {
        ExceptionMessage exceptionMessage = exceptionMessageMap.get(exceptionClass);
        if (Objects.nonNull(exceptionMessage)) {
            return exceptionMessage;
        }
        log.warn("The exception message is undefined. Try to get the super exception message!");
        return exceptionMessageMap.values().stream().filter(c -> c.getExceptionClass().isAssignableFrom(exceptionClass)).findFirst().orElse(DEFAULT_MESSAGE);
    }

    static {
        DEFAULT_MESSAGE = new ExceptionMessage(ErrorCode.INTERNAL_PROGRAM_ERROR);
        exceptionMessageMap = Arrays.stream(ErrorCode.values()).map(ExceptionMessage::new).filter(em -> Objects.nonNull(em.getExceptionClass())).collect(Collectors.toMap(ExceptionMessage::getExceptionClass, Function.identity(), (k1, k2) -> k2));
    }
}

