/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.aspect;

import java.util.Objects;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import top.lshaci.framework.web.annotation.PreventRepeatSubmit;
import top.lshaci.framework.web.exception.RepeatSubmitException;
import top.lshaci.framework.web.service.PreventRepeat;
import top.lshaci.framework.web.service.PreventRepeatKey;
import top.lshaci.framework.web.utils.HttpRequestUtils;

@Aspect
@Order(value=2)
public class PreventRepeatSubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(PreventRepeatSubmitAspect.class);
    private final PreventRepeat preventRepeat;
    private final PreventRepeatKey preventRepeatKey;

    @Pointcut(value="@annotation(top.lshaci.framework.web.annotation.PreventRepeatSubmit)")
    public void preventRepeatSubmit() {
    }

    @Before(value="@annotation(preventRepeatSubmit)")
    public void doBefore(PreventRepeatSubmit preventRepeatSubmit) {
        String submitKey = this.submitKey();
        log.debug("PreventRepeatSubmitAspect: the submit key is: {}.", (Object)submitKey);
        String value = this.preventRepeat.getAndSet(submitKey, preventRepeatSubmit.timeout());
        if (Objects.nonNull(value)) {
            log.warn("In operation...");
            throw new RepeatSubmitException();
        }
    }

    @AfterReturning(value="preventRepeatSubmit()")
    public void doAfterReturning() {
        String submitKey = this.submitKey();
        this.preventRepeat.remove(submitKey);
        log.debug("Remove the submit key: {}.", (Object)submitKey);
    }

    @AfterThrowing(value="preventRepeatSubmit()", throwing="e")
    public void doAfterThrowing(Exception e) {
        if (e instanceof RepeatSubmitException) {
            log.warn("In operation...");
            return;
        }
        String submitKey = this.submitKey();
        this.preventRepeat.remove(submitKey);
        log.debug("Remove the submit key: {}.", (Object)submitKey);
    }

    private String submitKey() {
        return this.preventRepeatKey.key(HttpRequestUtils.get());
    }

    public PreventRepeatSubmitAspect(PreventRepeat preventRepeat, PreventRepeatKey preventRepeatKey) {
        this.preventRepeat = preventRepeat;
        this.preventRepeatKey = preventRepeatKey;
    }
}

