/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.config;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;
import top.lshaci.framework.web.aspect.PreventRepeatSubmitAspect;
import top.lshaci.framework.web.exception.handler.GlobalExceptionHandler;
import top.lshaci.framework.web.model.ExceptionMessage;
import top.lshaci.framework.web.properties.FrameworkWebProperties;
import top.lshaci.framework.web.service.PreventRepeat;
import top.lshaci.framework.web.service.PreventRepeatKey;
import top.lshaci.framework.web.service.impl.RedisPreventRepeat;
import top.lshaci.framework.web.service.impl.TimedCachePreventRepeat;
import top.lshaci.framework.web.utils.GlobalExceptionUtils;

@Configuration
@EnableConfigurationProperties(value={FrameworkWebProperties.class})
public class FrameworkWebConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkWebConfig.class);
    private final FrameworkWebProperties properties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.web.global-exception-handle.enabled"}, havingValue="true", matchIfMissing=true)
    public GlobalExceptionHandler globalExceptionHandler() {
        log.debug("Config global exception handler...");
        List<ExceptionMessage> exceptionMessages = this.properties.getGlobalExceptionHandle().getMessages();
        if (!CollectionUtils.isEmpty(exceptionMessages)) {
            GlobalExceptionUtils.putAll(exceptionMessages);
        }
        return new GlobalExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public PreventRepeat preventRepeat() {
        log.debug("Config timed cache prevent repeat service...");
        return new TimedCachePreventRepeat(this.properties.getPreventRepeatSubmit().getTimeout());
    }

    @Bean
    @ConditionalOnMissingBean
    public PreventRepeatKey preventRepeatKey() {
        log.debug("Config prevent repeat submit key service...");
        return request -> request.getSession().getId() + ":" + request.getMethod() + ":" + request.getRequestURI();
    }

    @Bean
    @ConditionalOnProperty(value={"framework.web.prevent-repeat-submit.enabled"}, havingValue="true", matchIfMissing=true)
    public PreventRepeatSubmitAspect preventRepeatSubmitAspect(PreventRepeat preventRepeat, PreventRepeatKey preventRepeatKey) {
        log.debug("Config prevent repeat submit aspect...");
        return new PreventRepeatSubmitAspect(preventRepeat, preventRepeatKey);
    }

    public FrameworkWebConfig(FrameworkWebProperties properties) {
        this.properties = properties;
    }

    @Configuration
    @ConditionalOnBean(value={StringRedisTemplate.class})
    class RedisPreventRepeatConfig {
        RedisPreventRepeatConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public PreventRepeat preventRepeat(StringRedisTemplate stringRedisTemplate) {
            log.debug("Config redis prevent repeat service...");
            return new RedisPreventRepeat(FrameworkWebConfig.this.properties.getPreventRepeatSubmit().getTimeout(), stringRedisTemplate);
        }
    }
}

