/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.exception.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import top.lshaci.framework.common.exception.BaseException;
import top.lshaci.framework.common.model.JsonResponse;
import top.lshaci.framework.web.model.ExceptionMessage;
import top.lshaci.framework.web.utils.GlobalExceptionUtils;

@RestController
@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String SYSTEM_EXCEPTION = "System anomaly!";
    private static final String FIELD = "\u5b57\u6bb5:";

    @ExceptionHandler(value={BaseException.class})
    public JsonResponse<Object> baseExceptionHandler(BaseException e) {
        return JsonResponse.failure((String)e.getMessage()).setCode(e.getCode());
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public JsonResponse<Object> argumentExceptionHandler(Exception e) {
        log.error(SYSTEM_EXCEPTION, (Throwable)e);
        StringBuilder message = new StringBuilder();
        FieldError fieldError = null;
        if (e instanceof BindException) {
            BindException bindException = (BindException)e;
            fieldError = (FieldError)bindException.getBindingResult().getFieldErrors().get(0);
        } else if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException argumentNotValidException = (MethodArgumentNotValidException)e;
            fieldError = (FieldError)argumentNotValidException.getBindingResult().getFieldErrors().get(0);
        }
        if (fieldError != null) {
            String field = fieldError.getField();
            log.warn(FIELD + field);
            String msg = fieldError.getDefaultMessage();
            message.append(msg);
        }
        return JsonResponse.failure((String)message.toString());
    }

    @ExceptionHandler(value={Exception.class})
    public JsonResponse<Object> defaultExceptionHandler(Exception e) {
        log.error(SYSTEM_EXCEPTION, (Throwable)e);
        ExceptionMessage message = GlobalExceptionUtils.get(e.getClass());
        return JsonResponse.failure((String)message.getMessage()).setCode(message.getCode());
    }
}

