/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.service.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import top.lshaci.framework.web.service.PreventRepeat;

public class TimedCachePreventRepeat
implements PreventRepeat {
    private final long timeout;
    private final TimedCache<String, String> timedCache;

    public TimedCachePreventRepeat(long timeout) {
        this.timeout = timeout;
        this.timedCache = CacheUtil.newTimedCache((long)timeout);
        this.timedCache.schedulePrune(10L);
    }

    @Override
    public String getAndSet(String key, long timeout) {
        String value = (String)this.timedCache.get((Object)key, false);
        this.timedCache.put((Object)key, (Object)"true", timeout > 0L ? timeout : this.timeout);
        return value;
    }

    @Override
    public void remove(String key) {
        this.timedCache.remove((Object)key);
    }
}

