/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.lshaci.framework.common.model.JsonResponse;

public class HttpResponseUtils {
    public static HttpServletResponse get() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = requestAttributes.getResponse();
        Objects.requireNonNull(response, "The http response is null!");
        return response;
    }

    public static <R> void responseJson(JsonResponse<R> jsonResponse) throws IOException {
        HttpResponseUtils.responseJson(HttpResponseUtils.get(), jsonResponse);
    }

    public static <R> void responseJson(HttpServletResponse response, JsonResponse<R> jsonResponse) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().write(JSON.toJSONString(jsonResponse));
    }
}

