package top.lshaci.framework.web.service.impl;

import lombok.AllArgsConstructor;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.lshaci.framework.web.service.PreventRepeat;

import java.time.Duration;

import static java.util.concurrent.TimeUnit.MILLISECONDS;

/**
 * <p>Redis-based prevent repeat submit</p><br>
 *
 * <b>1.0.7:</b>This method <code>getAndSet</code> add parameter <code>timeout</code>
 *
 * @author lshaci
 * @since 1.0.5
 * @version 1.0.7
 */
@AllArgsConstructor
public class RedisPreventRepeat implements PreventRepeat {

    /**
     * The timeout of the submit key
     */
    private final Duration timeout;

    /**
     * The String Redis Template
     */
    private final StringRedisTemplate redisTemplate;

    @Override
    public boolean exists(String key, long timeout) {
        timeout = timeout > 0 ? timeout : this.timeout.toMillis();
        Boolean value = redisTemplate.opsForValue().setIfAbsent(key, VALUE, timeout, MILLISECONDS);
        return Boolean.FALSE.equals(value);
    }

    @Override
    public void remove(String key) {
        redisTemplate.delete(key);
    }
}
