package top.lshaci.framework.web.service.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.StrUtil;
import top.lshaci.framework.web.service.PreventRepeat;

import java.time.Duration;

/**
 * <p>Time cache prevent repeat submit</p><br>
 *
 * <b>1.0.7:</b>This method <code>getAndSet</code> add parameter <code>timeout</code>
 *
 * @author lshaci
 * @version 1.0.7
 * @since 1.0.5
 */
public class TimedCachePreventRepeat implements PreventRepeat {

    /**
     * The timeout of the submit key
     */
    private final long timeout;

    /**
     * Timed cache
     */
    private final TimedCache<String, String> timedCache;

    /**
     * Constructor a timed cache prevent repeat with the timeout
     *
     * @param timeout This timeout of the submit key
     */
    public TimedCachePreventRepeat(Duration timeout) {
        this.timeout = timeout.toMillis();
        timedCache = CacheUtil.newTimedCache(timeout.toMillis());
        timedCache.schedulePrune(10);
    }

    @Override
    public boolean exists(String key, long timeout) {
        String value = timedCache.get(key, false);
        if (StrUtil.isNotBlank(value)) {
            return true;
        } else {
            timedCache.put(key, VALUE, timeout > 0 ? timeout : this.timeout);
            return false;
        }
    }

    @Override
    public void remove(String key) {
        timedCache.remove(key);
    }
}
