/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.converter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class FastJsonConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(FastJsonConverterFactory.class);
    private FastJsonHttpMessageConverter fastJsonHttpMessageConverter;
    private FastJsonConfig fastJsonConfig;
    private Set<MediaType> supportedMediaTypes = new HashSet<MediaType>();

    private FastJsonConverterFactory() {
        log.debug("Init fast json http message converter...");
        this.fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        this.supportedMediaTypes.add(MediaType.TEXT_HTML);
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        this.fastJsonHttpMessageConverter.setSupportedMediaTypes(new ArrayList<MediaType>(this.supportedMediaTypes));
        this.fastJsonConfig = this.fastJsonHttpMessageConverter.getFastJsonConfig();
        this.fastJsonConfig.setDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static FastJsonConverterFactory build() {
        log.debug("Init fast json converter factory...");
        return new FastJsonConverterFactory();
    }

    public FastJsonConverterFactory setDateFormat(String dateFormat) {
        if (StrUtil.isNotEmpty((CharSequence)dateFormat)) {
            this.fastJsonConfig.setDateFormat(dateFormat);
            log.debug("Set fastJson config date format...");
        }
        return this;
    }

    public FastJsonConverterFactory addSerializerFeature(SerializerFeature ... serializerFeatures) {
        if (ArrayUtil.isNotEmpty((Object[])serializerFeatures)) {
            SerializerFeature[] oldSerializerFeatures = this.fastJsonConfig.getSerializerFeatures();
            SerializerFeature[] newSerializerFeatures = (SerializerFeature[])ArrayUtil.addAll((Object[][])new SerializerFeature[][]{oldSerializerFeatures, serializerFeatures});
            this.fastJsonConfig.setSerializerFeatures(newSerializerFeatures);
            log.debug("Add fastJson config serializerFeatures...");
        }
        return this;
    }

    public FastJsonConverterFactory addSerializerFeature(List<SerializerFeature> serializerFeatures) {
        if (CollectionUtil.isNotEmpty(serializerFeatures)) {
            this.addSerializerFeature(serializerFeatures.toArray(new SerializerFeature[serializerFeatures.size()]));
        }
        return this;
    }

    public FastJsonConverterFactory addSupportedMediaType(String mediaType) {
        if (StrUtil.isNotEmpty((CharSequence)mediaType)) {
            try {
                this.addSupportedMediaType(MediaType.parseMediaType((String)mediaType));
            }
            catch (Exception e) {
                log.warn("This string{} can not parse to a MediaType", (Object)mediaType);
            }
        }
        return this;
    }

    public FastJsonConverterFactory addSupportedMediaType(MediaType mediaType) {
        if (mediaType != null) {
            this.supportedMediaTypes.add(mediaType);
            this.refreshSupportedMediaTypes();
            log.debug("Add fast json http message converter supported media type...");
        }
        return this;
    }

    public FastJsonConverterFactory addSupportedMediaType(List<MediaType> mediaTypes) {
        if (CollectionUtil.isNotEmpty(mediaTypes)) {
            this.supportedMediaTypes.addAll(this.supportedMediaTypes);
            this.refreshSupportedMediaTypes();
        }
        return this;
    }

    private void refreshSupportedMediaTypes() {
        this.fastJsonHttpMessageConverter.setSupportedMediaTypes(new ArrayList<MediaType>(this.supportedMediaTypes));
    }

    public FastJsonHttpMessageConverter get() {
        return this.fastJsonHttpMessageConverter;
    }
}

