/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.exception.handler;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import top.lshaci.framework.common.exception.BaseException;
import top.lshaci.framework.common.model.JsonResponse;
import top.lshaci.framework.web.model.ExceptionMessage;
import top.lshaci.framework.web.utils.GlobalExceptionUtils;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Log log = LogFactory.get();

    @ExceptionHandler(value={BaseException.class})
    public JsonResponse<Object> baseExceptionHandler(HttpServletRequest req, BaseException e) {
        log.error((Throwable)e, "System anomaly => {} {}", new Object[]{req.getMethod(), req.getRequestURI()});
        return JsonResponse.failure((int)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public JsonResponse<Object> argumentExceptionHandler(HttpServletRequest req, Exception e) {
        log.error((Throwable)e, "System anomaly => {} {}", new Object[]{req.getMethod(), req.getRequestURI()});
        BindingResult bindingResult = null;
        if (e instanceof BindException) {
            bindingResult = ((BindException)e).getBindingResult();
        } else if (e instanceof MethodArgumentNotValidException) {
            bindingResult = ((MethodArgumentNotValidException)e).getBindingResult();
        }
        if (bindingResult == null) {
            return JsonResponse.failure();
        }
        List fieldErrors = bindingResult.getFieldErrors();
        JsonResponse r = JsonResponse.failure((int)400, (String)((FieldError)fieldErrors.get(0)).getDefaultMessage());
        fieldErrors.forEach(fe -> r.otherData(fe.getField(), (Object)fe.getDefaultMessage()));
        return r;
    }

    @ExceptionHandler(value={Exception.class})
    public JsonResponse<Object> defaultExceptionHandler(HttpServletRequest req, Exception e) {
        log.error((Throwable)e, "System anomaly => {} {}", new Object[]{req.getMethod(), req.getRequestURI()});
        ExceptionMessage message = GlobalExceptionUtils.get(e.getClass());
        return JsonResponse.failure((int)message.getCode(), (String)message.getMessage());
    }
}

