/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.service.impl;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.lshaci.framework.web.service.PreventRepeat;

public class RedisPreventRepeat
implements PreventRepeat {
    private final Duration timeout;
    private final StringRedisTemplate redisTemplate;

    @Override
    public boolean exists(String key, long timeout) {
        timeout = timeout > 0L ? timeout : this.timeout.toMillis();
        Boolean value = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"true", timeout, TimeUnit.MILLISECONDS);
        return Boolean.FALSE.equals(value);
    }

    @Override
    public void remove(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public RedisPreventRepeat(Duration timeout, StringRedisTemplate redisTemplate) {
        this.timeout = timeout;
        this.redisTemplate = redisTemplate;
    }
}

