/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.service.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.StrUtil;
import java.time.Duration;
import top.lshaci.framework.web.service.PreventRepeat;

public class TimedCachePreventRepeat
implements PreventRepeat {
    private final long timeout;
    private final TimedCache<String, String> timedCache;

    public TimedCachePreventRepeat(Duration timeout) {
        this.timeout = timeout.toMillis();
        this.timedCache = CacheUtil.newTimedCache((long)timeout.toMillis());
        this.timedCache.schedulePrune(10L);
    }

    @Override
    public boolean exists(String key, long timeout) {
        String value = (String)this.timedCache.get((Object)key, false);
        if (StrUtil.isNotBlank((CharSequence)value)) {
            return true;
        }
        this.timedCache.put((Object)key, (Object)"true", timeout > 0L ? timeout : this.timeout);
        return false;
    }

    @Override
    public void remove(String key) {
        this.timedCache.remove((Object)key);
    }
}

