/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.websocket.utils;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.common.exception.BaseException;

public class WebSocketUtils {
    private static final Logger log = LoggerFactory.getLogger(WebSocketUtils.class);
    private static Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();

    public static void add(String key, Session session) {
        WebSocketUtils.validateParameter(key, session);
        sessionMap.put(key, session);
        log.info("Add web socket session[{}] to the sessionMap success!", (Object)key);
    }

    public static void remove(String key) {
        WebSocketUtils.validateKey(key);
        boolean containsKey = sessionMap.containsKey(key);
        if (containsKey) {
            sessionMap.remove(key);
            log.info("Remove web socket session[{}] from sessionMap success!", (Object)key);
        } else {
            log.warn("The key[{}] not included in the sessionMap!", (Object)key);
        }
    }

    public static void sendMessage(String key, Object message) {
        WebSocketUtils.validateKey(key);
        Objects.requireNonNull(message, "The message must not be null!");
        Session session = sessionMap.get(key);
        if (session == null) {
            throw new BaseException("The key of the session not exist!");
        }
        try {
            session.getBasicRemote().sendText(JSON.toJSONString((Object)message));
        }
        catch (IOException e) {
            log.error("Sending message failed!", (Throwable)e);
            throw new BaseException("Sending message failed!");
        }
    }

    public static void sendMessage(Object message) {
        Objects.requireNonNull(message, "The message must not be null!");
        Collection<Session> sessions = sessionMap.values();
        for (Session session : sessions) {
            if (session == null) continue;
            try {
                session.getBasicRemote().sendText(JSON.toJSONString((Object)message));
            }
            catch (IOException e) {
                log.error("Sending message failed!", (Throwable)e);
            }
        }
    }

    private static void validateParameter(String key, Session session) {
        WebSocketUtils.validateKey(key);
        Objects.requireNonNull(session, "The web socket session must not be null!");
    }

    private static void validateKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseException("The unique key of the session must not be empty!");
        }
    }
}

