/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.dt.rmfc.common.model;

import com.lshaci.validate.annotation.Between;
import com.lshaci.validate.annotation.Json;
import com.lshaci.validate.annotation.Length;
import com.lshaci.validate.annotation.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import top.lshaci.dt.rmfc.common.enums.MessageStatus;

public class DtMessage
implements Serializable {
    private static final long serialVersionUID = 138880036196152217L;
    @Length(max=36)
    private String id;
    @Length(max=20, require=false)
    private String creator;
    @NotNull
    private Date createTime;
    @Length(max=50)
    private String confirmUrl;
    @Length(max=50)
    private String confirmParam;
    @Json
    private String content;
    @Length(max=100)
    private String queueName;
    private Date sendTime;
    @Between(min="3", max="10")
    private int retries;
    private int currentRetry;
    @NotNull
    private MessageStatus status;
    private Date receivedTime;
    @Length(max=200, require=false)
    private String remark;

    public DtMessage() {
    }

    public DtMessage(String confirmUrl, String confirmParam, String content, String queueName) {
        this.init();
        this.confirmUrl = confirmUrl;
        this.confirmParam = confirmParam;
        this.content = content;
        this.queueName = queueName;
    }

    public DtMessage(String creator, String confirmUrl, String confirmParam, String content, String queueName, int retries, String remark) {
        this(confirmUrl, confirmParam, content, queueName);
        this.creator = creator;
        this.retries = retries;
        this.remark = remark;
    }

    private void init() {
        this.id = UUID.randomUUID().toString();
        this.createTime = new Date();
        this.currentRetry = 0;
        this.status = MessageStatus.WAITSEND;
    }

    public void addRetry() {
        ++this.currentRetry;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getConfirmUrl() {
        return this.confirmUrl;
    }

    public void setConfirmUrl(String confirmUrl) {
        this.confirmUrl = confirmUrl;
    }

    public String getConfirmParam() {
        return this.confirmParam;
    }

    public void setConfirmParam(String confirmParam) {
        this.confirmParam = confirmParam;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getCurrentRetry() {
        return this.currentRetry;
    }

    public void setCurrentRetry(int currentRetry) {
        this.currentRetry = currentRetry;
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public void setStatus(MessageStatus status) {
        this.status = status;
    }

    public Date getReceivedTime() {
        return this.receivedTime;
    }

    public void setReceivedTime(Date receivedTime) {
        this.receivedTime = receivedTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String toString() {
        return "DtMessage [id=" + this.id + ", creator=" + this.creator + ", createTime=" + this.createTime + ", confirmUrl=" + this.confirmUrl + ", confirmParam=" + this.confirmParam + ", content=" + this.content + ", queueName=" + this.queueName + ", sendTime=" + this.sendTime + ", retries=" + this.retries + ", currentRetry=" + this.currentRetry + ", status=" + (Object)((Object)this.status) + ", receivedTime=" + this.receivedTime + ", remark=" + this.remark + "]";
    }
}

