/*
 * Decompiled with CFR 0.152.
 */
package top.mao196.calcobject.obj;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import top.mao196.calcobject.obj.CalcObject;
import top.mao196.calcobject.obj.CalcType;

public class CalcDate
extends CalcObject {
    private final LocalDate value;

    public CalcDate(LocalDate value) {
        this.value = value;
    }

    public CalcDate(String value) {
        this.value = LocalDate.parse(value);
    }

    public CalcDate(int year, int month, int day) {
        this.value = LocalDate.of(year, month, day);
    }

    public static CalcObject valueOf(LocalDate obj) {
        return new CalcDate(obj);
    }

    public Date dateValue() {
        return Date.from(this.value.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public LocalDate localDateValue() {
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public CalcType getCalcType() {
        return CalcType.DATE;
    }
}

