/*
 * Decompiled with CFR 0.152.
 */
package top.mao196.calcobject.obj;

import java.math.BigDecimal;
import java.math.BigInteger;
import top.mao196.calcobject.obj.CalcNumber;
import top.mao196.calcobject.obj.CalcType;

public class CalcLong
extends CalcNumber {
    private final long value;

    private CalcLong(long value) {
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public static CalcLong valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new CalcLong(l);
    }

    public static CalcLong valueOf(Long l) {
        return CalcLong.valueOf((long)l);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public BigDecimal bigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public BigInteger bigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public CalcType getCalcType() {
        return CalcType.LONG;
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    private static class LongCache {
        static final CalcLong[] cache = new CalcLong[256];

        private LongCache() {
        }

        static {
            for (long i = 0L; i < (long)cache.length; ++i) {
                LongCache.cache[(int)i] = new CalcLong(i - 128L);
            }
        }
    }
}

